#delimit ;
clear;
set memory 1g;

use "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Regressions\Organize Data\dataforlaborsupply_noexclus.dta";;

recode edu (5=4);
gen parent=1 if kidsunder6>0 & !missing(kidsunder6) | kids6to18>0 & !missing(kids6to18);
replace parent=0 if missing(parent) & !missing(kidsunder6) | missing(parent) & !missing(kids6to18);

gen crossmarhead=1 if married==1 & head==1;
replace crossmarhead=2 if married==1 & head==0;
replace crossmarhead=3 if married==0 & head==1;
replace crossmarhead=4 if married==0 & head==0;

label define crossmarhead 
	1 "Married, head of household"
	2 "Married, not head of household"
	3 "Unmarried, head of household"
	4 "Unmarried, not head of household";
label values crossmarhead crossmarhead;

gen crossparmar1=1 if married==0 & parent==1;
replace crossparmar1=2 if married==0 & parent==0;
replace crossparmar1=3 if married==1;

label define crossparmar1
	1 "Unmarried parent"
	2 "Unmarried non-parent"
	3 "Married";

label values crossparmar1 crossparmar1;

gen crossparmar2=1 if married==0 & parent==1;
replace crossparmar2=2 if married==0 & parent==0;
replace crossparmar2=3 if married==1 & parent==1;
replace crossparmar2=4 if married==1 & parent==0;

label define crossparmar2
	1 "Unmarried parent"
	2 "Unmarried nonparent"
	3 "Married parent"
	4 "Married nonparent";
label values crossparmar2 crossparmar2;


keep if year==1999 | year==2007;

drop if age==5; /*Eliminate 65+*/
drop if a_lfsr==0; /*Eliminate members of armed force*/
drop if a_fnlwgt==0;


preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(age edu year parent sex);
sort sex parent year edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\parent.xls", replace;
restore;

preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(year parent sex);
sort sex parent year;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\OverallParent.xls", replace;
restore;


/*
preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(age edu year crossmarhead sex);
sort sex crossmarhead year edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\crossmarhead.xls", replace;
restore;

preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(year crossmarhead sex);
sort sex crossmarhead year;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\Overallcrossmarhead.xls", replace;
restore;

preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(age edu year crossparmar1 sex);
sort sex crossparmar1 year edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\crossparmar1.xls", replace;
restore;

preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(age edu year crossparmar2 sex);
sort sex crossparmar2 year edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\crossparmar2.xls", replace;
restore;

preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(year crossparmar1 sex);
sort sex crossparmar1 year;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\Overallcrossparmar1.xls", replace;
restore;

preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(year crossparmar2 sex);
sort sex crossparmar2 year;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\Overallcrossparmar2.xls", replace;
restore;


/*
preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(age edu year headhh sex);
sort sex headhh year edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\HeadHH99to07.xls", replace;

restore; preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(year headhh sex);
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\OverallHeadHH99to07.xls", replace;


restore; preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(age sex married edu year);
sort sex married year edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\Married99to07.xls", replace;

restore; preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(year married sex);
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\OverallMarried99to07.xls", replace;

restore; preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(age sex parent edu year);
sort sex parent year edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\Parent99to07.xls", replace;

restore; preserve;
collapse (mean) employed [pweight=a_fnlwgt], by(year parent sex);
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\OverallParent99to07.xls", replace;
*/

preserve;
collapse (mean) employed [pweight=a_fnlwgt] if married==0, by(age sex edu year);
sort sex year edu age;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\Unmarried99to07.xls", replace;

restore; preserve;
collapse (mean) employed [pweight=a_fnlwgt] if married==0, by(sex year);
sort sex year;
outsheet using "C:\Users\Nicole\Desktop\Labor Supply RA\CPS extracts\MarchCPS\Table 1 with both datasets\By subgroup\OverallUnmarried99to07.xls", replace;
